package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.XmlString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledActionsResponse(
    scheduledActions: Option[
      Iterable[zio.aws.applicationautoscaling.model.ScheduledAction]
    ] = None,
    nextToken: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse = {
    import DescribeScheduledActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
      .builder()
      .optionallyWith(
        scheduledActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledActions)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse =
      zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse(
        scheduledActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scheduledActions: Option[
      List[zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly]
    ]
    def nextToken: Option[XmlString]
    def getScheduledActions: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledActions", scheduledActions)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ) extends zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly {
    override val scheduledActions: Option[
      List[zio.aws.applicationautoscaling.model.ScheduledAction.ReadOnly]
    ] = scala
      .Option(impl.scheduledActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.applicationautoscaling.model.ScheduledAction.wrap(item)
        }.toList
      )
    override val nextToken: Option[XmlString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsResponse
  ): zio.aws.applicationautoscaling.model.DescribeScheduledActionsResponse.ReadOnly =
    new Wrapper(impl)
}
