package zio.aws.applicationautoscaling.model
import java.lang.Integer
import zio.aws.applicationautoscaling.model.primitives.{
  XmlString,
  MaxResults,
  ResourceIdMaxLen1600
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeScheduledActionsRequest(
    scheduledActionNames: Option[Iterable[ResourceIdMaxLen1600]] = None,
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    resourceId: Option[ResourceIdMaxLen1600] = None,
    scalableDimension: Option[
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest = {
    import DescribeScheduledActionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest
      .builder()
      .optionallyWith(
        scheduledActionNames.map(value =>
          value.map { item =>
            ResourceIdMaxLen1600.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scheduledActionNames)
      .serviceNamespace(serviceNamespace.unwrap)
      .optionallyWith(
        resourceId.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(scalableDimension.map(value => value.unwrap))(
        _.scalableDimension
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest
      .wrap(buildAwsValue())
}
object DescribeScheduledActionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest =
      zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest(
        scheduledActionNames.map(value => value),
        serviceNamespace,
        resourceId.map(value => value),
        scalableDimension.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def scheduledActionNames: Option[List[ResourceIdMaxLen1600]]
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def resourceId: Option[ResourceIdMaxLen1600]
    def scalableDimension
        : Option[zio.aws.applicationautoscaling.model.ScalableDimension]
    def maxResults: Option[MaxResults]
    def nextToken: Option[XmlString]
    def getScheduledActionNames
        : ZIO[Any, AwsError, List[ResourceIdMaxLen1600]] =
      AwsError.unwrapOptionField("scheduledActionNames", scheduledActionNames)
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getScalableDimension: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = AwsError.unwrapOptionField("scalableDimension", scalableDimension)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest
  ) extends zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest.ReadOnly {
    override val scheduledActionNames: Option[List[ResourceIdMaxLen1600]] =
      scala
        .Option(impl.scheduledActionNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationautoscaling.model.primitives
              .ResourceIdMaxLen1600(item)
          }.toList
        )
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: Option[ResourceIdMaxLen1600] = scala
      .Option(impl.resourceId())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives
          .ResourceIdMaxLen1600(value)
      )
    override val scalableDimension
        : Option[zio.aws.applicationautoscaling.model.ScalableDimension] = scala
      .Option(impl.scalableDimension())
      .map(value =>
        zio.aws.applicationautoscaling.model.ScalableDimension.wrap(value)
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.MaxResults(value)
      )
    override val nextToken: Option[XmlString] = scala
      .Option(impl.nextToken())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.XmlString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.DescribeScheduledActionsRequest
  ): zio.aws.applicationautoscaling.model.DescribeScheduledActionsRequest.ReadOnly =
    new Wrapper(impl)
}
