package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.ResourceIdMaxLen1600
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class PutScalingPolicyResponse(
    policyARN: ResourceIdMaxLen1600,
    alarms: Option[Iterable[zio.aws.applicationautoscaling.model.Alarm]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse = {
    import PutScalingPolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse
      .builder()
      .policyARN(ResourceIdMaxLen1600.unwrap(policyARN): java.lang.String)
      .optionallyWith(
        alarms.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alarms)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly =
    zio.aws.applicationautoscaling.model.PutScalingPolicyResponse
      .wrap(buildAwsValue())
}
object PutScalingPolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.PutScalingPolicyResponse =
      zio.aws.applicationautoscaling.model.PutScalingPolicyResponse(
        policyARN,
        alarms.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyARN: ResourceIdMaxLen1600
    def alarms
        : Option[List[zio.aws.applicationautoscaling.model.Alarm.ReadOnly]]
    def getPolicyARN: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(policyARN)
    def getAlarms: ZIO[Any, AwsError, List[
      zio.aws.applicationautoscaling.model.Alarm.ReadOnly
    ]] = AwsError.unwrapOptionField("alarms", alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse
  ) extends zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly {
    override val policyARN: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.policyARN())
    override val alarms
        : Option[List[zio.aws.applicationautoscaling.model.Alarm.ReadOnly]] =
      scala
        .Option(impl.alarms())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.applicationautoscaling.model.Alarm.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScalingPolicyResponse
  ): zio.aws.applicationautoscaling.model.PutScalingPolicyResponse.ReadOnly =
    new Wrapper(impl)
}
