package zio.aws.applicationautoscaling.model
import zio.aws.applicationautoscaling.model.primitives.{
  TimestampType,
  ScheduledActionName,
  ResourceIdMaxLen1600
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PutScheduledActionRequest(
    serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace,
    schedule: Option[ResourceIdMaxLen1600] = None,
    timezone: Option[ResourceIdMaxLen1600] = None,
    scheduledActionName: ScheduledActionName,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.applicationautoscaling.model.ScalableDimension,
    startTime: Option[TimestampType] = None,
    endTime: Option[TimestampType] = None,
    scalableTargetAction: Option[
      zio.aws.applicationautoscaling.model.ScalableTargetAction
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest = {
    import PutScheduledActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .optionallyWith(
        schedule.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.schedule)
      .optionallyWith(
        timezone.map(value =>
          ResourceIdMaxLen1600.unwrap(value): java.lang.String
        )
      )(_.timezone)
      .scheduledActionName(
        ScheduledActionName.unwrap(scheduledActionName): java.lang.String
      )
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .optionallyWith(
        startTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(scalableTargetAction.map(value => value.buildAwsValue()))(
        _.scalableTargetAction
      )
      .build()
  }
  def asReadOnly
      : zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly =
    zio.aws.applicationautoscaling.model.PutScheduledActionRequest
      .wrap(buildAwsValue())
}
object PutScheduledActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.applicationautoscaling.model.PutScheduledActionRequest =
      zio.aws.applicationautoscaling.model.PutScheduledActionRequest(
        serviceNamespace,
        schedule.map(value => value),
        timezone.map(value => value),
        scheduledActionName,
        resourceId,
        scalableDimension,
        startTime.map(value => value),
        endTime.map(value => value),
        scalableTargetAction.map(value => value.asEditable)
      )
    def serviceNamespace: zio.aws.applicationautoscaling.model.ServiceNamespace
    def schedule: Option[ResourceIdMaxLen1600]
    def timezone: Option[ResourceIdMaxLen1600]
    def scheduledActionName: ScheduledActionName
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension
    def startTime: Option[TimestampType]
    def endTime: Option[TimestampType]
    def scalableTargetAction: Option[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ]
    def getServiceNamespace: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ServiceNamespace
    ] = ZIO.succeed(serviceNamespace)
    def getSchedule: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getTimezone: ZIO[Any, AwsError, ResourceIdMaxLen1600] =
      AwsError.unwrapOptionField("timezone", timezone)
    def getScheduledActionName: ZIO[Any, Nothing, ScheduledActionName] =
      ZIO.succeed(scheduledActionName)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension: ZIO[
      Any,
      Nothing,
      zio.aws.applicationautoscaling.model.ScalableDimension
    ] = ZIO.succeed(scalableDimension)
    def getStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getScalableTargetAction: ZIO[
      Any,
      AwsError,
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = AwsError.unwrapOptionField("scalableTargetAction", scalableTargetAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ) extends zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly {
    override val serviceNamespace
        : zio.aws.applicationautoscaling.model.ServiceNamespace =
      zio.aws.applicationautoscaling.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val schedule: Option[ResourceIdMaxLen1600] = scala
      .Option(impl.schedule())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives
          .ResourceIdMaxLen1600(value)
      )
    override val timezone: Option[ResourceIdMaxLen1600] = scala
      .Option(impl.timezone())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives
          .ResourceIdMaxLen1600(value)
      )
    override val scheduledActionName: ScheduledActionName =
      zio.aws.applicationautoscaling.model.primitives
        .ScheduledActionName(impl.scheduledActionName())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.applicationautoscaling.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.applicationautoscaling.model.ScalableDimension =
      zio.aws.applicationautoscaling.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val startTime: Option[TimestampType] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val endTime: Option[TimestampType] = scala
      .Option(impl.endTime())
      .map(value =>
        zio.aws.applicationautoscaling.model.primitives.TimestampType(value)
      )
    override val scalableTargetAction: Option[
      zio.aws.applicationautoscaling.model.ScalableTargetAction.ReadOnly
    ] = scala
      .Option(impl.scalableTargetAction())
      .map(value =>
        zio.aws.applicationautoscaling.model.ScalableTargetAction.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationautoscaling.model.PutScheduledActionRequest
  ): zio.aws.applicationautoscaling.model.PutScheduledActionRequest.ReadOnly =
    new Wrapper(impl)
}
