package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  Description,
  ApplicationName,
  ArnOrUUID
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationRequest(
    arn: ArnOrUUID,
    name: Optional[ApplicationName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig
    ] = Optional.Absent,
    subscriptions: Optional[
      Iterable[zio.aws.appintegrations.model.Subscription]
    ] = Optional.Absent,
    publications: Optional[
      Iterable[zio.aws.appintegrations.model.Publication]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest = {
    import UpdateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest
      .builder()
      .arn(ArnOrUUID.unwrap(arn): java.lang.String)
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        applicationSourceConfig.map(value => value.buildAwsValue())
      )(_.applicationSourceConfig)
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .optionallyWith(
        publications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.publications)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.UpdateApplicationRequest.ReadOnly =
    zio.aws.appintegrations.model.UpdateApplicationRequest.wrap(buildAwsValue())
}
object UpdateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.UpdateApplicationRequest =
      zio.aws.appintegrations.model.UpdateApplicationRequest(
        arn,
        name.map(value => value),
        description.map(value => value),
        applicationSourceConfig.map(value => value.asEditable),
        subscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def arn: ArnOrUUID
    def name: Optional[ApplicationName]
    def description: Optional[Description]
    def applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ]
    def subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]]
    def publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]]
    def getArn: ZIO[Any, Nothing, ArnOrUUID] = ZIO.succeed(arn)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationSourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSourceConfig",
      applicationSourceConfig
    )
    def getSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Subscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptions", subscriptions)
    def getPublications: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Publication.ReadOnly
    ]] = AwsError.unwrapOptionField("publications", publications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest
  ) extends zio.aws.appintegrations.model.UpdateApplicationRequest.ReadOnly {
    override val arn: ArnOrUUID =
      zio.aws.appintegrations.model.primitives.ArnOrUUID(impl.arn())
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.appintegrations.model.primitives.ApplicationName(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSourceConfig())
      .map(value =>
        zio.aws.appintegrations.model.ApplicationSourceConfig.wrap(value)
      )
    override val subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Subscription.wrap(item)
          }.toList
        )
    override val publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Publication.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest
  ): zio.aws.appintegrations.model.UpdateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
