package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListApplicationsResponse(
    applications: Optional[
      Iterable[zio.aws.appintegrations.model.ApplicationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse = {
    import ListApplicationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse
      .builder()
      .optionallyWith(
        applications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applications)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly =
    zio.aws.appintegrations.model.ListApplicationsResponse.wrap(buildAwsValue())
}
object ListApplicationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ListApplicationsResponse =
      zio.aws.appintegrations.model.ListApplicationsResponse(
        applications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def applications: Optional[
      List[zio.aws.appintegrations.model.ApplicationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getApplications: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("applications", applications)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse
  ) extends zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly {
    override val applications: Optional[
      List[zio.aws.appintegrations.model.ApplicationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appintegrations.model.ApplicationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListApplicationsResponse
  ): zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly =
    new Wrapper(impl)
}
