package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.ArnOrUUID
import scala.jdk.CollectionConverters.*
final case class GetApplicationRequest(arn: ArnOrUUID) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest = {
    import GetApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest
      .builder()
      .arn(ArnOrUUID.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.GetApplicationRequest.ReadOnly =
    zio.aws.appintegrations.model.GetApplicationRequest.wrap(buildAwsValue())
}
object GetApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.GetApplicationRequest =
      zio.aws.appintegrations.model.GetApplicationRequest(arn)
    def arn: ArnOrUUID
    def getArn: ZIO[Any, Nothing, ArnOrUUID] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest
  ) extends zio.aws.appintegrations.model.GetApplicationRequest.ReadOnly {
    override val arn: ArnOrUUID =
      zio.aws.appintegrations.model.primitives.ArnOrUUID(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest
  ): zio.aws.appintegrations.model.GetApplicationRequest.ReadOnly = new Wrapper(
    impl
  )
}
