package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ApplicationSourceConfig(
    externalUrlConfig: Optional[
      zio.aws.appintegrations.model.ExternalUrlConfig
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig = {
    import ApplicationSourceConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig
      .builder()
      .optionallyWith(externalUrlConfig.map(value => value.buildAwsValue()))(
        _.externalUrlConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly =
    zio.aws.appintegrations.model.ApplicationSourceConfig.wrap(buildAwsValue())
}
object ApplicationSourceConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ApplicationSourceConfig =
      zio.aws.appintegrations.model.ApplicationSourceConfig(
        externalUrlConfig.map(value => value.asEditable)
      )
    def externalUrlConfig
        : Optional[zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly]
    def getExternalUrlConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly
    ] = AwsError.unwrapOptionField("externalUrlConfig", externalUrlConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig
  ) extends zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly {
    override val externalUrlConfig
        : Optional[zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalUrlConfig())
        .map(value =>
          zio.aws.appintegrations.model.ExternalUrlConfig.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ApplicationSourceConfig
  ): zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly =
    new Wrapper(impl)
}
