package zio.aws.appintegrations
import zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient
import zio.aws.core.AwsError
import zio.aws.appintegrations.model.{
  UpdateApplicationRequest,
  UpdateDataIntegrationRequest,
  GetDataIntegrationRequest,
  ListEventIntegrationsRequest,
  UpdateEventIntegrationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteEventIntegrationRequest,
  GetEventIntegrationRequest,
  ListEventIntegrationAssociationsRequest,
  GetApplicationRequest,
  CreateEventIntegrationRequest,
  UntagResourceRequest,
  ListDataIntegrationsRequest,
  ListApplicationsRequest,
  CreateDataIntegrationRequest,
  DeleteDataIntegrationRequest,
  ListDataIntegrationAssociationsRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object AppIntegrationsMock extends Mock[AppIntegrations] {
  object GetApplication
      extends Effect[
        GetApplicationRequest,
        AwsError,
        zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly
      ]
  object ListEventIntegrations
      extends Stream[
        ListEventIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.EventIntegration.ReadOnly
      ]
  object ListEventIntegrationsPaginated
      extends Effect[
        ListEventIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
      ]
  object CreateEventIntegration
      extends Effect[
        CreateEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
      ]
  object ListEventIntegrationAssociations
      extends Stream[
        ListEventIntegrationAssociationsRequest,
        AwsError,
        ReadOnly
      ]
  object ListEventIntegrationAssociationsPaginated
      extends Effect[
        ListEventIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
      ]
  object ListDataIntegrationAssociations
      extends Stream[
        ListDataIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
      ]
  object ListDataIntegrationAssociationsPaginated
      extends Effect[
        ListDataIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
      ]
  object GetDataIntegration
      extends Effect[
        GetDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
      ]
  object CreateApplication
      extends Effect[
        CreateApplicationRequest,
        AwsError,
        zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly
      ]
  object GetEventIntegration
      extends Effect[
        GetEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
      ]
  object DeleteDataIntegration
      extends Effect[
        DeleteDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateEventIntegration
      extends Effect[
        UpdateEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
      ]
  object ListApplications
      extends Stream[
        ListApplicationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
      ]
  object ListApplicationsPaginated
      extends Effect[
        ListApplicationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly
      ]
  object DeleteEventIntegration
      extends Effect[
        DeleteEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
      ]
  object CreateDataIntegration
      extends Effect[
        CreateDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
      ]
  object UpdateDataIntegration
      extends Effect[
        UpdateDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
      ]
  object UpdateApplication
      extends Effect[
        UpdateApplicationRequest,
        AwsError,
        zio.aws.appintegrations.model.UpdateApplicationResponse.ReadOnly
      ]
  object ListDataIntegrations
      extends Stream[
        ListDataIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
      ]
  object ListDataIntegrationsPaginated
      extends Effect[
        ListDataIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppIntegrations] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppIntegrations] { rts =>
        zio.ZIO.succeed {
          new AppIntegrations {
            val api: AppIntegrationsAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppIntegrations = this
            def getApplication(request: GetApplicationRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly
            ] = proxy(GetApplication, request)
            def listEventIntegrations(
                request: ListEventIntegrationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appintegrations.model.EventIntegration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListEventIntegrations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listEventIntegrationsPaginated(
                request: ListEventIntegrationsRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
            ] = proxy(ListEventIntegrationsPaginated, request)
            def createEventIntegration(
                request: CreateEventIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
            ] = proxy(CreateEventIntegration, request)
            def listEventIntegrationAssociations(
                request: ListEventIntegrationAssociationsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListEventIntegrationAssociations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listEventIntegrationAssociationsPaginated(
                request: ListEventIntegrationAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
            ] = proxy(ListEventIntegrationAssociationsPaginated, request)
            def listDataIntegrationAssociations(
                request: ListDataIntegrationAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataIntegrationAssociations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataIntegrationAssociationsPaginated(
                request: ListDataIntegrationAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
            ] = proxy(ListDataIntegrationAssociationsPaginated, request)
            def getDataIntegration(request: GetDataIntegrationRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
            ] = proxy(GetDataIntegration, request)
            def createApplication(request: CreateApplicationRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly
            ] = proxy(CreateApplication, request)
            def getEventIntegration(request: GetEventIntegrationRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
            ] = proxy(GetEventIntegration, request)
            def deleteDataIntegration(
                request: DeleteDataIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
            ] = proxy(DeleteDataIntegration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def updateEventIntegration(
                request: UpdateEventIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
            ] = proxy(UpdateEventIntegration, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listApplications(request: ListApplicationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListApplications, request)
                }
                .getOrThrowFiberFailure()
            }
            def listApplicationsPaginated(request: ListApplicationsRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly
            ] = proxy(ListApplicationsPaginated, request)
            def deleteEventIntegration(
                request: DeleteEventIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
            ] = proxy(DeleteEventIntegration, request)
            def createDataIntegration(
                request: CreateDataIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
            ] = proxy(CreateDataIntegration, request)
            def updateDataIntegration(
                request: UpdateDataIntegrationRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
            ] = proxy(UpdateDataIntegration, request)
            def updateApplication(request: UpdateApplicationRequest): IO[
              AwsError,
              zio.aws.appintegrations.model.UpdateApplicationResponse.ReadOnly
            ] = proxy(UpdateApplication, request)
            def listDataIntegrations(
                request: ListDataIntegrationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListDataIntegrations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listDataIntegrationsPaginated(
                request: ListDataIntegrationsRequest
            ): IO[
              AwsError,
              zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
            ] = proxy(ListDataIntegrationsPaginated, request)
          }
        }
      }
    }
  }
}
