package zio.aws.appintegrations
import zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.appintegrations.{
  AppIntegrationsAsyncClientBuilder,
  AppIntegrationsAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.appintegrations.model.{
  UpdateApplicationRequest,
  UpdateDataIntegrationRequest,
  GetDataIntegrationRequest,
  ListEventIntegrationsRequest,
  UpdateEventIntegrationRequest,
  CreateApplicationRequest,
  ListTagsForResourceRequest,
  DeleteEventIntegrationRequest,
  GetEventIntegrationRequest,
  ListEventIntegrationAssociationsRequest,
  GetApplicationRequest,
  CreateEventIntegrationRequest,
  UntagResourceRequest,
  ListDataIntegrationsRequest,
  ListApplicationsRequest,
  CreateDataIntegrationRequest,
  DeleteDataIntegrationRequest,
  ListDataIntegrationAssociationsRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.appintegrations.model.{
  CreateDataIntegrationResponse,
  ListEventIntegrationAssociationsResponse,
  DeleteEventIntegrationResponse,
  DataIntegrationSummary,
  DeleteDataIntegrationResponse,
  UpdateApplicationResponse,
  DataIntegrationAssociationSummary,
  EventIntegration,
  UpdateDataIntegrationResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  ListApplicationsResponse,
  EventIntegrationAssociation,
  ListDataIntegrationsResponse,
  CreateApplicationResponse,
  UpdateEventIntegrationResponse,
  ListEventIntegrationsResponse,
  CreateEventIntegrationResponse,
  ListDataIntegrationAssociationsResponse,
  TagResourceResponse,
  ApplicationSummary,
  GetApplicationResponse,
  GetEventIntegrationResponse,
  GetDataIntegrationResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait AppIntegrations extends AspectSupport[AppIntegrations] {
  val api: AppIntegrationsAsyncClient
  def getApplication(
      request: GetApplicationRequest
  ): IO[AwsError, zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly]
  def listEventIntegrations(request: ListEventIntegrationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.appintegrations.model.EventIntegration.ReadOnly
  ]
  def listEventIntegrationsPaginated(request: ListEventIntegrationsRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
  ]
  def createEventIntegration(request: CreateEventIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
  ]
  def listEventIntegrationAssociations(
      request: ListEventIntegrationAssociationsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listEventIntegrationAssociationsPaginated(
      request: ListEventIntegrationAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
  ]
  def listDataIntegrationAssociations(
      request: ListDataIntegrationAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
  ]
  def listDataIntegrationAssociationsPaginated(
      request: ListDataIntegrationAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
  ]
  def getDataIntegration(request: GetDataIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
  ]
  def createApplication(request: CreateApplicationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly
  ]
  def getEventIntegration(request: GetEventIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
  ]
  def deleteDataIntegration(request: DeleteDataIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
  ]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly]
  def updateEventIntegration(request: UpdateEventIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
  ]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.appintegrations.model.TagResourceResponse.ReadOnly]
  def listApplications(request: ListApplicationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
  ]
  def listApplicationsPaginated(request: ListApplicationsRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly
  ]
  def deleteEventIntegration(request: DeleteEventIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
  ]
  def createDataIntegration(request: CreateDataIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
  ]
  def updateDataIntegration(request: UpdateDataIntegrationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
  ]
  def updateApplication(request: UpdateApplicationRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.UpdateApplicationResponse.ReadOnly
  ]
  def listDataIntegrations(request: ListDataIntegrationsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
  ]
  def listDataIntegrationsPaginated(request: ListDataIntegrationsRequest): IO[
    AwsError,
    zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
  ]
}
object AppIntegrations {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppIntegrations] =
    customized(identity)
  def customized(
      customization: AppIntegrationsAsyncClientBuilder => AppIntegrationsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppIntegrations] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AppIntegrationsAsyncClientBuilder => AppIntegrationsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AppIntegrations] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AppIntegrationsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppIntegrationsAsyncClient, AppIntegrationsAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      AppIntegrationsAsyncClient,
      AppIntegrationsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new AppIntegrationsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AppIntegrationsImpl[R](
      override val api: AppIntegrationsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppIntegrations
      with AwsServiceBase[R] {
    override val serviceName: String = "AppIntegrations"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppIntegrationsImpl[R1] = new AppIntegrationsImpl(api, newAspect, r)
    def getApplication(request: GetApplicationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.GetApplicationRequest,
      GetApplicationResponse
    ]("getApplication", api.getApplication)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.GetApplicationResponse.wrap)
      .provideEnvironment(r)
    def listEventIntegrations(request: ListEventIntegrationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.appintegrations.model.EventIntegration.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest,
      ListEventIntegrationsResponse,
      EventIntegration
    ](
      "listEventIntegrations",
      api.listEventIntegrations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventIntegrations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appintegrations.model.EventIntegration.wrap(item))
      .provideEnvironment(r)
    def listEventIntegrationsPaginated(
        request: ListEventIntegrationsRequest
    ): IO[
      AwsError,
      zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest,
      ListEventIntegrationsResponse
    ]("listEventIntegrations", api.listEventIntegrations)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.ListEventIntegrationsResponse.wrap)
      .provideEnvironment(r)
    def createEventIntegration(request: CreateEventIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest,
      CreateEventIntegrationResponse
    ]("createEventIntegration", api.createEventIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.CreateEventIntegrationResponse.wrap)
      .provideEnvironment(r)
    def listEventIntegrationAssociations(
        request: ListEventIntegrationAssociationsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest,
      ListEventIntegrationAssociationsResponse,
      EventIntegrationAssociation
    ](
      "listEventIntegrationAssociations",
      api.listEventIntegrationAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.eventIntegrationAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appintegrations.model.EventIntegrationAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def listEventIntegrationAssociationsPaginated(
        request: ListEventIntegrationAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest,
      ListEventIntegrationAssociationsResponse
    ]("listEventIntegrationAssociations", api.listEventIntegrationAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.wrap
    ).provideEnvironment(r)
    def listDataIntegrationAssociations(
        request: ListDataIntegrationAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest,
      ListDataIntegrationAssociationsResponse,
      DataIntegrationAssociationSummary
    ](
      "listDataIntegrationAssociations",
      api.listDataIntegrationAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataIntegrationAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appintegrations.model.DataIntegrationAssociationSummary
          .wrap(item)
      )
      .provideEnvironment(r)
    def listDataIntegrationAssociationsPaginated(
        request: ListDataIntegrationAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest,
      ListDataIntegrationAssociationsResponse
    ]("listDataIntegrationAssociations", api.listDataIntegrationAssociations)(
      request.buildAwsValue()
    ).map(
      zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.wrap
    ).provideEnvironment(r)
    def getDataIntegration(request: GetDataIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest,
      GetDataIntegrationResponse
    ]("getDataIntegration", api.getDataIntegration)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.GetDataIntegrationResponse.wrap)
      .provideEnvironment(r)
    def createApplication(request: CreateApplicationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest,
      CreateApplicationResponse
    ]("createApplication", api.createApplication)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.CreateApplicationResponse.wrap)
      .provideEnvironment(r)
    def getEventIntegration(request: GetEventIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationRequest,
      GetEventIntegrationResponse
    ]("getEventIntegration", api.getEventIntegration)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.GetEventIntegrationResponse.wrap)
      .provideEnvironment(r)
    def deleteDataIntegration(request: DeleteDataIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest,
      DeleteDataIntegrationResponse
    ]("deleteDataIntegration", api.deleteDataIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.DeleteDataIntegrationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def updateEventIntegration(request: UpdateEventIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest,
      UpdateEventIntegrationResponse
    ]("updateEventIntegration", api.updateEventIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.UpdateEventIntegrationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def listApplications(request: ListApplicationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest,
      ListApplicationsResponse,
      ApplicationSummary
    ](
      "listApplications",
      api.listApplications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.applications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.appintegrations.model.ApplicationSummary.wrap(item))
      .provideEnvironment(r)
    def listApplicationsPaginated(request: ListApplicationsRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListApplicationsRequest,
      ListApplicationsResponse
    ]("listApplications", api.listApplications)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.ListApplicationsResponse.wrap)
      .provideEnvironment(r)
    def deleteEventIntegration(request: DeleteEventIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest,
      DeleteEventIntegrationResponse
    ]("deleteEventIntegration", api.deleteEventIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.DeleteEventIntegrationResponse.wrap)
      .provideEnvironment(r)
    def createDataIntegration(request: CreateDataIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest,
      CreateDataIntegrationResponse
    ]("createDataIntegration", api.createDataIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.CreateDataIntegrationResponse.wrap)
      .provideEnvironment(r)
    def updateDataIntegration(request: UpdateDataIntegrationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest,
      UpdateDataIntegrationResponse
    ]("updateDataIntegration", api.updateDataIntegration)(
      request.buildAwsValue()
    ).map(zio.aws.appintegrations.model.UpdateDataIntegrationResponse.wrap)
      .provideEnvironment(r)
    def updateApplication(request: UpdateApplicationRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.UpdateApplicationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.UpdateApplicationRequest,
      UpdateApplicationResponse
    ]("updateApplication", api.updateApplication)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.UpdateApplicationResponse.wrap)
      .provideEnvironment(r)
    def listDataIntegrations(request: ListDataIntegrationsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest,
      ListDataIntegrationsResponse,
      DataIntegrationSummary
    ](
      "listDataIntegrations",
      api.listDataIntegrations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.dataIntegrations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.appintegrations.model.DataIntegrationSummary.wrap(item)
      )
      .provideEnvironment(r)
    def listDataIntegrationsPaginated(request: ListDataIntegrationsRequest): IO[
      AwsError,
      zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsRequest,
      ListDataIntegrationsResponse
    ]("listDataIntegrations", api.listDataIntegrations)(request.buildAwsValue())
      .map(zio.aws.appintegrations.model.ListDataIntegrationsResponse.wrap)
      .provideEnvironment(r)
  }
  def getApplication(request: GetApplicationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getApplication(request))
  def listEventIntegrations(request: ListEventIntegrationsRequest): ZStream[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.EventIntegration.ReadOnly
  ] = ZStream.serviceWithStream(_.listEventIntegrations(request))
  def listEventIntegrationsPaginated(
      request: ListEventIntegrationsRequest
  ): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventIntegrationsPaginated(request))
  def createEventIntegration(request: CreateEventIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventIntegration(request))
  def listEventIntegrationAssociations(
      request: ListEventIntegrationAssociationsRequest
  ): ZStream[zio.aws.appintegrations.AppIntegrations, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listEventIntegrationAssociations(request))
  def listEventIntegrationAssociationsPaginated(
      request: ListEventIntegrationAssociationsRequest
  ): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listEventIntegrationAssociationsPaginated(request))
  def listDataIntegrationAssociations(
      request: ListDataIntegrationAssociationsRequest
  ): ZStream[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataIntegrationAssociations(request))
  def listDataIntegrationAssociationsPaginated(
      request: ListDataIntegrationAssociationsRequest
  ): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataIntegrationAssociationsPaginated(request))
  def getDataIntegration(request: GetDataIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDataIntegration(request))
  def createApplication(request: CreateApplicationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createApplication(request))
  def getEventIntegration(request: GetEventIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEventIntegration(request))
  def deleteDataIntegration(request: DeleteDataIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDataIntegration(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def updateEventIntegration(request: UpdateEventIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventIntegration(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listApplications(request: ListApplicationsRequest): ZStream[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ApplicationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listApplications(request))
  def listApplicationsPaginated(request: ListApplicationsRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListApplicationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listApplicationsPaginated(request))
  def deleteEventIntegration(request: DeleteEventIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventIntegration(request))
  def createDataIntegration(request: CreateDataIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDataIntegration(request))
  def updateDataIntegration(request: UpdateDataIntegrationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateDataIntegration(request))
  def updateApplication(request: UpdateApplicationRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.UpdateApplicationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateApplication(request))
  def listDataIntegrations(request: ListDataIntegrationsRequest): ZStream[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
  ] = ZStream.serviceWithStream(_.listDataIntegrations(request))
  def listDataIntegrationsPaginated(request: ListDataIntegrationsRequest): ZIO[
    zio.aws.appintegrations.AppIntegrations,
    AwsError,
    zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listDataIntegrationsPaginated(request))
}
