package zio.aws.appintegrations
import zio.prelude.Subtype
import zio.aws.appintegrations.model.primitives.{
  Fields,
  TagValue,
  NonBlankString,
  NonBlankLongString,
  TagKey
}
import zio.aws.appintegrations.model.primitives.ClientId.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object Arn extends Subtype[String]
    type Arn = zio.aws.appintegrations.model.primitives.Arn.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.appintegrations.model.primitives.ClientId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appintegrations.model.primitives.Description.Type
    object EventBridgeBus extends Subtype[String]
    type EventBridgeBus =
      zio.aws.appintegrations.model.primitives.EventBridgeBus.Type
    object EventBridgeRuleName extends Subtype[String]
    type EventBridgeRuleName =
      zio.aws.appintegrations.model.primitives.EventBridgeRuleName.Type
    object Fields extends Subtype[String]
    type Fields = zio.aws.appintegrations.model.primitives.Fields.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.appintegrations.model.primitives.IdempotencyToken.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.appintegrations.model.primitives.Identifier.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appintegrations.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.appintegrations.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.appintegrations.model.primitives.NextToken.Type
    object NonBlankLongString extends Subtype[String]
    type NonBlankLongString =
      zio.aws.appintegrations.model.primitives.NonBlankLongString.Type
    object NonBlankString extends Subtype[String]
    type NonBlankString =
      zio.aws.appintegrations.model.primitives.NonBlankString.Type
    object Object extends Subtype[String]
    type Object = zio.aws.appintegrations.model.primitives.Object.Type
    object Source extends Subtype[String]
    type Source = zio.aws.appintegrations.model.primitives.Source.Type
    object SourceURI extends Subtype[String]
    type SourceURI = zio.aws.appintegrations.model.primitives.SourceURI.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appintegrations.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appintegrations.model.primitives.TagValue.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.appintegrations.model.primitives.UUID.Type
  }
  type ClientAssociationMetadata = Map[NonBlankString, NonBlankString]
  type DataIntegrationAssociationsList =
    List[zio.aws.appintegrations.model.DataIntegrationAssociationSummary]
  type DataIntegrationsList =
    List[zio.aws.appintegrations.model.DataIntegrationSummary]
  type EventIntegrationAssociationsList =
    List[zio.aws.appintegrations.model.EventIntegrationAssociation]
  type EventIntegrationsList =
    List[zio.aws.appintegrations.model.EventIntegration]
  type FieldsList = List[Fields]
  type FieldsMap = Map[NonBlankString, Iterable[Fields]]
  type FolderList = List[NonBlankLongString]
  type ObjectConfiguration =
    Map[NonBlankString, Map[NonBlankString, Iterable[Fields]]]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
