package zio.aws.appintegrations.model
import zio.prelude.data.Optional
import zio.aws.appintegrations.model.primitives.{MaxResults, NextToken, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEventIntegrationAssociationsRequest(
    eventIntegrationName: Name,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest = {
    import ListEventIntegrationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
      .builder()
      .eventIntegrationName(Name.unwrap(eventIntegrationName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest
      .wrap(buildAwsValue())
}
object ListEventIntegrationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest =
      zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest(
        eventIntegrationName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def eventIntegrationName: Name
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getEventIntegrationName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(eventIntegrationName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ) extends zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly {
    override val eventIntegrationName: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.eventIntegrationName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ): zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
