package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  EventBridgeBus,
  TagValue,
  IdempotencyToken,
  Description,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEventIntegrationRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    eventFilter: zio.aws.appintegrations.model.EventFilter,
    eventBridgeBus: EventBridgeBus,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest = {
    import CreateEventIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .eventFilter(eventFilter.buildAwsValue())
      .eventBridgeBus(EventBridgeBus.unwrap(eventBridgeBus): java.lang.String)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateEventIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.CreateEventIntegrationRequest
      .wrap(buildAwsValue())
}
object CreateEventIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.CreateEventIntegrationRequest =
      zio.aws.appintegrations.model.CreateEventIntegrationRequest(
        name,
        description.map(value => value),
        eventFilter.asEditable,
        eventBridgeBus,
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def eventFilter: zio.aws.appintegrations.model.EventFilter.ReadOnly
    def eventBridgeBus: EventBridgeBus
    def clientToken: Optional[IdempotencyToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEventFilter: ZIO[
      Any,
      Nothing,
      zio.aws.appintegrations.model.EventFilter.ReadOnly
    ] = ZIO.succeed(eventFilter)
    def getEventBridgeBus: ZIO[Any, Nothing, EventBridgeBus] =
      ZIO.succeed(eventBridgeBus)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest
  ) extends zio.aws.appintegrations.model.CreateEventIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val eventFilter
        : zio.aws.appintegrations.model.EventFilter.ReadOnly =
      zio.aws.appintegrations.model.EventFilter.wrap(impl.eventFilter())
    override val eventBridgeBus: EventBridgeBus =
      zio.aws.appintegrations.model.primitives
        .EventBridgeBus(impl.eventBridgeBus())
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationRequest
  ): zio.aws.appintegrations.model.CreateEventIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
