package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  Fields,
  SourceURI,
  TagValue,
  IdempotencyToken,
  Description,
  NonBlankString,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataIntegrationRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    kmsKey: NonBlankString,
    sourceURI: SourceURI,
    scheduleConfig: zio.aws.appintegrations.model.ScheduleConfiguration,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    fileConfiguration: Optional[
      zio.aws.appintegrations.model.FileConfiguration
    ] = Optional.Absent,
    objectConfiguration: Optional[
      Map[NonBlankString, Map[NonBlankString, Iterable[Fields]]]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest = {
    import CreateDataIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .kmsKey(NonBlankString.unwrap(kmsKey): java.lang.String)
      .sourceURI(SourceURI.unwrap(sourceURI): java.lang.String)
      .scheduleConfig(scheduleConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue.unwrap(
                value
              ): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(fileConfiguration.map(value => value.buildAwsValue()))(
        _.fileConfiguration
      )
      .optionallyWith(
        objectConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (NonBlankString.unwrap(key): java.lang.String) -> value
                .map({ case (key, value) =>
                  (NonBlankString.unwrap(key): java.lang.String) -> value.map {
                    item =>
                      Fields.unwrap(item): java.lang.String
                  }.asJavaCollection
                })
                .asJava
            })
            .asJava
        )
      )(_.objectConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.CreateDataIntegrationRequest
      .wrap(buildAwsValue())
}
object CreateDataIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.CreateDataIntegrationRequest =
      zio.aws.appintegrations.model.CreateDataIntegrationRequest(
        name,
        description.map(value => value),
        kmsKey,
        sourceURI,
        scheduleConfig.asEditable,
        tags.map(value => value),
        clientToken.map(value => value),
        fileConfiguration.map(value => value.asEditable),
        objectConfiguration.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def kmsKey: NonBlankString
    def sourceURI: SourceURI
    def scheduleConfig
        : zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[IdempotencyToken]
    def fileConfiguration
        : Optional[zio.aws.appintegrations.model.FileConfiguration.ReadOnly]
    def objectConfiguration
        : Optional[Map[NonBlankString, Map[NonBlankString, List[Fields]]]]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKey: ZIO[Any, Nothing, NonBlankString] = ZIO.succeed(kmsKey)
    def getSourceURI: ZIO[Any, Nothing, SourceURI] = ZIO.succeed(sourceURI)
    def getScheduleConfig: ZIO[
      Any,
      Nothing,
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] = ZIO.succeed(scheduleConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getFileConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.FileConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("fileConfiguration", fileConfiguration)
    def getObjectConfiguration
        : ZIO[Any, AwsError, Map[NonBlankString, Map[NonBlankString, List[
          Fields
        ]]]] =
      AwsError.unwrapOptionField("objectConfiguration", objectConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ) extends zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val kmsKey: NonBlankString =
      zio.aws.appintegrations.model.primitives.NonBlankString(impl.kmsKey())
    override val sourceURI: SourceURI =
      zio.aws.appintegrations.model.primitives.SourceURI(impl.sourceURI())
    override val scheduleConfig
        : zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly =
      zio.aws.appintegrations.model.ScheduleConfiguration
        .wrap(impl.scheduleConfig())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
    override val fileConfiguration
        : Optional[zio.aws.appintegrations.model.FileConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileConfiguration())
        .map(value =>
          zio.aws.appintegrations.model.FileConfiguration.wrap(value)
        )
    override val objectConfiguration
        : Optional[Map[NonBlankString, Map[NonBlankString, List[Fields]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.objectConfiguration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appintegrations.model.primitives
                .NonBlankString(key) -> value.asScala
                .map({ case (key, value) =>
                  zio.aws.appintegrations.model.primitives
                    .NonBlankString(key) -> value.asScala.map { item =>
                    zio.aws.appintegrations.model.primitives.Fields(item)
                  }.toList
                })
                .toMap
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ): zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
