package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataIntegrationsResponse(
    dataIntegrations: Optional[
      Iterable[zio.aws.appintegrations.model.DataIntegrationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse = {
    import ListDataIntegrationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse
      .builder()
      .optionallyWith(
        dataIntegrations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataIntegrations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly =
    zio.aws.appintegrations.model.ListDataIntegrationsResponse
      .wrap(buildAwsValue())
}
object ListDataIntegrationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ListDataIntegrationsResponse =
      zio.aws.appintegrations.model.ListDataIntegrationsResponse(
        dataIntegrations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataIntegrations: Optional[
      List[zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getDataIntegrations: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("dataIntegrations", dataIntegrations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse
  ) extends zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly {
    override val dataIntegrations: Optional[
      List[zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.dataIntegrations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appintegrations.model.DataIntegrationSummary.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationsResponse
  ): zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly =
    new Wrapper(impl)
}
