package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{Description, Name, Identifier}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateDataIntegrationRequest(
    identifier: Identifier,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest = {
    import UpdateDataIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.UpdateDataIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.UpdateDataIntegrationRequest
      .wrap(buildAwsValue())
}
object UpdateDataIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.UpdateDataIntegrationRequest =
      zio.aws.appintegrations.model.UpdateDataIntegrationRequest(
        identifier,
        name.map(value => value),
        description.map(value => value)
      )
    def identifier: Identifier
    def name: Optional[Name]
    def description: Optional[Description]
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest
  ) extends zio.aws.appintegrations.model.UpdateDataIntegrationRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.appintegrations.model.primitives.Identifier(impl.identifier())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateDataIntegrationRequest
  ): zio.aws.appintegrations.model.UpdateDataIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
