package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDataIntegrationAssociationsResponse(
    dataIntegrationAssociations: Optional[
      Iterable[zio.aws.appintegrations.model.DataIntegrationAssociationSummary]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse = {
    import ListDataIntegrationAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse
      .builder()
      .optionallyWith(
        dataIntegrationAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataIntegrationAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly =
    zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse
      .wrap(buildAwsValue())
}
object ListDataIntegrationAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse =
      zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse(
        dataIntegrationAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def dataIntegrationAssociations: Optional[List[
      zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getDataIntegrationAssociations: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "dataIntegrationAssociations",
      dataIntegrationAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse
  ) extends zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly {
    override val dataIntegrationAssociations: Optional[List[
      zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.dataIntegrationAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appintegrations.model.DataIntegrationAssociationSummary
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsResponse
  ): zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
