package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.Name
import scala.jdk.CollectionConverters.*
final case class DeleteEventIntegrationRequest(name: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest = {
    import DeleteEventIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.DeleteEventIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.DeleteEventIntegrationRequest
      .wrap(buildAwsValue())
}
object DeleteEventIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.DeleteEventIntegrationRequest =
      zio.aws.appintegrations.model.DeleteEventIntegrationRequest(name)
    def name: Name
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest
  ) extends zio.aws.appintegrations.model.DeleteEventIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.DeleteEventIntegrationRequest
  ): zio.aws.appintegrations.model.DeleteEventIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
