package zio.aws.appintegrations.model
import zio.prelude.data.Optional
import zio.aws.appintegrations.model.primitives.{
  MaxResults,
  NextToken,
  Identifier
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListDataIntegrationAssociationsRequest(
    dataIntegrationIdentifier: Identifier,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest = {
    import ListDataIntegrationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
      .builder()
      .dataIntegrationIdentifier(
        Identifier.unwrap(dataIntegrationIdentifier): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest
      .wrap(buildAwsValue())
}
object ListDataIntegrationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest =
      zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest(
        dataIntegrationIdentifier,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dataIntegrationIdentifier: Identifier
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getDataIntegrationIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(dataIntegrationIdentifier)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ) extends zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly {
    override val dataIntegrationIdentifier: Identifier =
      zio.aws.appintegrations.model.primitives
        .Identifier(impl.dataIntegrationIdentifier())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ): zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
