package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  TagValue,
  IdempotencyToken,
  Description,
  NonBlankString,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataIntegrationRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent,
    kmsKey: Optional[NonBlankString] = Optional.Absent,
    sourceURI: Optional[NonBlankString] = Optional.Absent,
    scheduleConfig: Optional[
      zio.aws.appintegrations.model.ScheduleConfiguration
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest = {
    import CreateDataIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        kmsKey.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        sourceURI.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.sourceURI)
      .optionallyWith(scheduleConfig.map(value => value.buildAwsValue()))(
        _.scheduleConfig
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.CreateDataIntegrationRequest
      .wrap(buildAwsValue())
}
object CreateDataIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.CreateDataIntegrationRequest =
      zio.aws.appintegrations.model.CreateDataIntegrationRequest(
        name,
        description.map(value => value),
        kmsKey.map(value => value),
        sourceURI.map(value => value),
        scheduleConfig.map(value => value.asEditable),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def name: Name
    def description: Optional[Description]
    def kmsKey: Optional[NonBlankString]
    def sourceURI: Optional[NonBlankString]
    def scheduleConfig
        : Optional[zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[IdempotencyToken]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKey: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getSourceURI: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("sourceURI", sourceURI)
    def getScheduleConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("scheduleConfig", scheduleConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ) extends zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val kmsKey: Optional[NonBlankString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val sourceURI: Optional[NonBlankString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceURI())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val scheduleConfig: Optional[
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleConfig())
      .map(value =>
        zio.aws.appintegrations.model.ScheduleConfiguration.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationRequest
  ): zio.aws.appintegrations.model.CreateDataIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
