package zio.aws.appintegrations.model
import zio.prelude.data.Optional
import zio.aws.appintegrations.model.primitives.{MaxResults, NextToken}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListEventIntegrationsRequest(
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest = {
    import ListEventIntegrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationsRequest
      .wrap(buildAwsValue())
}
object ListEventIntegrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ListEventIntegrationsRequest =
      zio.aws.appintegrations.model.ListEventIntegrationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ) extends zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ): zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly =
    new Wrapper(impl)
}
