package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  EventBridgeRuleName,
  Arn,
  ClientId,
  NonBlankString,
  UUID,
  Name
}
import scala.jdk.CollectionConverters.*
final case class EventIntegrationAssociation(
    eventIntegrationAssociationArn: Option[Arn] = None,
    eventIntegrationAssociationId: Option[UUID] = None,
    eventIntegrationName: Option[Name] = None,
    clientId: Option[ClientId] = None,
    eventBridgeRuleName: Option[EventBridgeRuleName] = None,
    clientAssociationMetadata: Option[Map[NonBlankString, NonBlankString]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation = {
    import EventIntegrationAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation
      .builder()
      .optionallyWith(
        eventIntegrationAssociationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.eventIntegrationAssociationArn)
      .optionallyWith(
        eventIntegrationAssociationId.map(value =>
          UUID.unwrap(value): java.lang.String
        )
      )(_.eventIntegrationAssociationId)
      .optionallyWith(
        eventIntegrationName.map(value => Name.unwrap(value): java.lang.String)
      )(_.eventIntegrationName)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        eventBridgeRuleName.map(value =>
          EventBridgeRuleName.unwrap(value): java.lang.String
        )
      )(_.eventBridgeRuleName)
      .optionallyWith(
        clientAssociationMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (NonBlankString.unwrap(key): java.lang.String) -> (NonBlankString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.clientAssociationMetadata)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly =
    zio.aws.appintegrations.model.EventIntegrationAssociation
      .wrap(buildAwsValue())
}
object EventIntegrationAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.EventIntegrationAssociation =
      zio.aws.appintegrations.model.EventIntegrationAssociation(
        eventIntegrationAssociationArn.map(value => value),
        eventIntegrationAssociationId.map(value => value),
        eventIntegrationName.map(value => value),
        clientId.map(value => value),
        eventBridgeRuleName.map(value => value),
        clientAssociationMetadata.map(value => value)
      )
    def eventIntegrationAssociationArn: Option[Arn]
    def eventIntegrationAssociationId: Option[UUID]
    def eventIntegrationName: Option[Name]
    def clientId: Option[ClientId]
    def eventBridgeRuleName: Option[EventBridgeRuleName]
    def clientAssociationMetadata: Option[Map[NonBlankString, NonBlankString]]
    def getEventIntegrationAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "eventIntegrationAssociationArn",
        eventIntegrationAssociationArn
      )
    def getEventIntegrationAssociationId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField(
        "eventIntegrationAssociationId",
        eventIntegrationAssociationId
      )
    def getEventIntegrationName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("eventIntegrationName", eventIntegrationName)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getEventBridgeRuleName: ZIO[Any, AwsError, EventBridgeRuleName] =
      AwsError.unwrapOptionField("eventBridgeRuleName", eventBridgeRuleName)
    def getClientAssociationMetadata
        : ZIO[Any, AwsError, Map[NonBlankString, NonBlankString]] = AwsError
      .unwrapOptionField("clientAssociationMetadata", clientAssociationMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation
  ) extends zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly {
    override val eventIntegrationAssociationArn: Option[Arn] = scala
      .Option(impl.eventIntegrationAssociationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val eventIntegrationAssociationId: Option[UUID] = scala
      .Option(impl.eventIntegrationAssociationId())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
    override val eventIntegrationName: Option[Name] = scala
      .Option(impl.eventIntegrationName())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val clientId: Option[ClientId] = scala
      .Option(impl.clientId())
      .map(value => zio.aws.appintegrations.model.primitives.ClientId(value))
    override val eventBridgeRuleName: Option[EventBridgeRuleName] = scala
      .Option(impl.eventBridgeRuleName())
      .map(value =>
        zio.aws.appintegrations.model.primitives.EventBridgeRuleName(value)
      )
    override val clientAssociationMetadata
        : Option[Map[NonBlankString, NonBlankString]] = scala
      .Option(impl.clientAssociationMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.NonBlankString(
              key
            ) -> zio.aws.appintegrations.model.primitives.NonBlankString(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegrationAssociation
  ): zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly =
    new Wrapper(impl)
}
