package zio.aws.appintegrations.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{MaxResults, NextToken}
import scala.jdk.CollectionConverters.*
final case class ListEventIntegrationsRequest(
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest = {
    import ListEventIntegrationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationsRequest
      .wrap(buildAwsValue())
}
object ListEventIntegrationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ListEventIntegrationsRequest =
      zio.aws.appintegrations.model.ListEventIntegrationsRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ) extends zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly {
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationsRequest
  ): zio.aws.appintegrations.model.ListEventIntegrationsRequest.ReadOnly =
    new Wrapper(impl)
}
