package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  EventBridgeBus,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class EventIntegration(
    eventIntegrationArn: Option[Arn] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    eventFilter: Option[zio.aws.appintegrations.model.EventFilter] = None,
    eventBridgeBus: Option[EventBridgeBus] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.EventIntegration = {
    import EventIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.EventIntegration
      .builder()
      .optionallyWith(
        eventIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventIntegrationArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(
        eventBridgeBus.map(value =>
          EventBridgeBus.unwrap(value): java.lang.String
        )
      )(_.eventBridgeBus)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.EventIntegration.ReadOnly =
    zio.aws.appintegrations.model.EventIntegration.wrap(buildAwsValue())
}
object EventIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.EventIntegration =
      zio.aws.appintegrations.model.EventIntegration(
        eventIntegrationArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        eventFilter.map(value => value.asEditable),
        eventBridgeBus.map(value => value),
        tags.map(value => value)
      )
    def eventIntegrationArn: Option[Arn]
    def name: Option[Name]
    def description: Option[Description]
    def eventFilter: Option[zio.aws.appintegrations.model.EventFilter.ReadOnly]
    def eventBridgeBus: Option[EventBridgeBus]
    def tags: Option[Map[TagKey, TagValue]]
    def getEventIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventIntegrationArn", eventIntegrationArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEventFilter: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.EventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getEventBridgeBus: ZIO[Any, AwsError, EventBridgeBus] =
      AwsError.unwrapOptionField("eventBridgeBus", eventBridgeBus)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ) extends zio.aws.appintegrations.model.EventIntegration.ReadOnly {
    override val eventIntegrationArn: Option[Arn] = scala
      .Option(impl.eventIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val eventFilter
        : Option[zio.aws.appintegrations.model.EventFilter.ReadOnly] = scala
      .Option(impl.eventFilter())
      .map(value => zio.aws.appintegrations.model.EventFilter.wrap(value))
    override val eventBridgeBus: Option[EventBridgeBus] = scala
      .Option(impl.eventBridgeBus())
      .map(value =>
        zio.aws.appintegrations.model.primitives.EventBridgeBus(value)
      )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ): zio.aws.appintegrations.model.EventIntegration.ReadOnly = new Wrapper(impl)
}
