package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.Identifier
import scala.jdk.CollectionConverters.*
final case class DeleteDataIntegrationRequest(
    dataIntegrationIdentifier: Identifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest = {
    import DeleteDataIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest
      .builder()
      .dataIntegrationIdentifier(
        Identifier.unwrap(dataIntegrationIdentifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.DeleteDataIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.DeleteDataIntegrationRequest
      .wrap(buildAwsValue())
}
object DeleteDataIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.DeleteDataIntegrationRequest =
      zio.aws.appintegrations.model
        .DeleteDataIntegrationRequest(dataIntegrationIdentifier)
    def dataIntegrationIdentifier: Identifier
    def getDataIntegrationIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(dataIntegrationIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest
  ) extends zio.aws.appintegrations.model.DeleteDataIntegrationRequest.ReadOnly {
    override val dataIntegrationIdentifier: Identifier =
      zio.aws.appintegrations.model.primitives
        .Identifier(impl.dataIntegrationIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.DeleteDataIntegrationRequest
  ): zio.aws.appintegrations.model.DeleteDataIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
