package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  TagValue,
  Arn,
  IdempotencyToken,
  Description,
  NonBlankString,
  UUID,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters.*
final case class CreateDataIntegrationResponse(
    arn: Option[Arn] = None,
    id: Option[UUID] = None,
    name: Option[Name] = None,
    description: Option[Description] = None,
    kmsKey: Option[NonBlankString] = None,
    sourceURI: Option[NonBlankString] = None,
    scheduleConfiguration: Option[
      zio.aws.appintegrations.model.ScheduleConfiguration
    ] = None,
    tags: Option[Map[TagKey, TagValue]] = None,
    clientToken: Option[IdempotencyToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse = {
    import CreateDataIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        kmsKey.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        sourceURI.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.sourceURI)
      .optionallyWith(
        scheduleConfiguration.map(value => value.buildAwsValue())
      )(_.scheduleConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly =
    zio.aws.appintegrations.model.CreateDataIntegrationResponse
      .wrap(buildAwsValue())
}
object CreateDataIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.CreateDataIntegrationResponse =
      zio.aws.appintegrations.model.CreateDataIntegrationResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        kmsKey.map(value => value),
        sourceURI.map(value => value),
        scheduleConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def arn: Option[Arn]
    def id: Option[UUID]
    def name: Option[Name]
    def description: Option[Description]
    def kmsKey: Option[NonBlankString]
    def sourceURI: Option[NonBlankString]
    def scheduleConfiguration
        : Option[zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def clientToken: Option[IdempotencyToken]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKey: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getSourceURI: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("sourceURI", sourceURI)
    def getScheduleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("scheduleConfiguration", scheduleConfiguration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ) extends zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val id: Option[UUID] = scala
      .Option(impl.id())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val kmsKey: Option[NonBlankString] = scala
      .Option(impl.kmsKey())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val sourceURI: Option[NonBlankString] = scala
      .Option(impl.sourceURI())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val scheduleConfiguration
        : Option[zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly] =
      scala
        .Option(impl.scheduleConfiguration())
        .map(value =>
          zio.aws.appintegrations.model.ScheduleConfiguration.wrap(value)
        )
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Option[IdempotencyToken] = scala
      .Option(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ): zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
