package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.Identifier
import scala.jdk.CollectionConverters.*
final case class GetDataIntegrationRequest(identifier: Identifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest = {
    import GetDataIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest
      .builder()
      .identifier(Identifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.GetDataIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.GetDataIntegrationRequest
      .wrap(buildAwsValue())
}
object GetDataIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.GetDataIntegrationRequest =
      zio.aws.appintegrations.model.GetDataIntegrationRequest(identifier)
    def identifier: Identifier
    def getIdentifier: ZIO[Any, Nothing, Identifier] = ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest
  ) extends zio.aws.appintegrations.model.GetDataIntegrationRequest.ReadOnly {
    override val identifier: Identifier =
      zio.aws.appintegrations.model.primitives.Identifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.GetDataIntegrationRequest
  ): zio.aws.appintegrations.model.GetDataIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
