package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{NonBlankString, Name, Arn}
import scala.jdk.CollectionConverters.*
final case class DataIntegrationSummary(
    arn: Option[Arn] = None,
    name: Option[Name] = None,
    sourceURI: Option[NonBlankString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary = {
    import DataIntegrationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        sourceURI.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.sourceURI)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly =
    zio.aws.appintegrations.model.DataIntegrationSummary.wrap(buildAwsValue())
}
object DataIntegrationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.DataIntegrationSummary =
      zio.aws.appintegrations.model.DataIntegrationSummary(
        arn.map(value => value),
        name.map(value => value),
        sourceURI.map(value => value)
      )
    def arn: Option[Arn]
    def name: Option[Name]
    def sourceURI: Option[NonBlankString]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getSourceURI: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("sourceURI", sourceURI)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ) extends zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly {
    override val arn: Option[Arn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val sourceURI: Option[NonBlankString] = scala
      .Option(impl.sourceURI())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationSummary
  ): zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly =
    new Wrapper(impl)
}
