package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.Arn
import scala.jdk.CollectionConverters.*
final case class CreateEventIntegrationResponse(
    eventIntegrationArn: Option[Arn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse = {
    import CreateEventIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
      .builder()
      .optionallyWith(
        eventIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventIntegrationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly =
    zio.aws.appintegrations.model.CreateEventIntegrationResponse
      .wrap(buildAwsValue())
}
object CreateEventIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.CreateEventIntegrationResponse =
      zio.aws.appintegrations.model
        .CreateEventIntegrationResponse(eventIntegrationArn.map(value => value))
    def eventIntegrationArn: Option[Arn]
    def getEventIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventIntegrationArn", eventIntegrationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ) extends zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly {
    override val eventIntegrationArn: Option[Arn] = scala
      .Option(impl.eventIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ): zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
