package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  EventBridgeBus,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EventIntegration(
    eventIntegrationArn: Optional[Arn] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    eventFilter: Optional[zio.aws.appintegrations.model.EventFilter] =
      Optional.Absent,
    eventBridgeBus: Optional[EventBridgeBus] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.EventIntegration = {
    import EventIntegration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.EventIntegration
      .builder()
      .optionallyWith(
        eventIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventIntegrationArn)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(
        eventBridgeBus.map(value =>
          EventBridgeBus.unwrap(value): java.lang.String
        )
      )(_.eventBridgeBus)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.EventIntegration.ReadOnly =
    zio.aws.appintegrations.model.EventIntegration.wrap(buildAwsValue())
}
object EventIntegration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.EventIntegration =
      zio.aws.appintegrations.model.EventIntegration(
        eventIntegrationArn.map(value => value),
        name.map(value => value),
        description.map(value => value),
        eventFilter.map(value => value.asEditable),
        eventBridgeBus.map(value => value),
        tags.map(value => value)
      )
    def eventIntegrationArn: Optional[Arn]
    def name: Optional[Name]
    def description: Optional[Description]
    def eventFilter
        : Optional[zio.aws.appintegrations.model.EventFilter.ReadOnly]
    def eventBridgeBus: Optional[EventBridgeBus]
    def tags: Optional[Map[TagKey, TagValue]]
    def getEventIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventIntegrationArn", eventIntegrationArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEventFilter: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.EventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getEventBridgeBus: ZIO[Any, AwsError, EventBridgeBus] =
      AwsError.unwrapOptionField("eventBridgeBus", eventBridgeBus)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ) extends zio.aws.appintegrations.model.EventIntegration.ReadOnly {
    override val eventIntegrationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val eventFilter
        : Optional[zio.aws.appintegrations.model.EventFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventFilter())
        .map(value => zio.aws.appintegrations.model.EventFilter.wrap(value))
    override val eventBridgeBus: Optional[EventBridgeBus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventBridgeBus())
        .map(value =>
          zio.aws.appintegrations.model.primitives.EventBridgeBus(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.EventIntegration
  ): zio.aws.appintegrations.model.EventIntegration.ReadOnly = new Wrapper(impl)
}
