package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{ClientId, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataIntegrationAssociationSummary(
    dataIntegrationAssociationArn: Optional[Arn] = Optional.Absent,
    dataIntegrationArn: Optional[Arn] = Optional.Absent,
    clientId: Optional[ClientId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary = {
    import DataIntegrationAssociationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary
      .builder()
      .optionallyWith(
        dataIntegrationAssociationArn.map(value =>
          Arn.unwrap(value): java.lang.String
        )
      )(_.dataIntegrationAssociationArn)
      .optionallyWith(
        dataIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.dataIntegrationArn)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly =
    zio.aws.appintegrations.model.DataIntegrationAssociationSummary
      .wrap(buildAwsValue())
}
object DataIntegrationAssociationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.DataIntegrationAssociationSummary =
      zio.aws.appintegrations.model.DataIntegrationAssociationSummary(
        dataIntegrationAssociationArn.map(value => value),
        dataIntegrationArn.map(value => value),
        clientId.map(value => value)
      )
    def dataIntegrationAssociationArn: Optional[Arn]
    def dataIntegrationArn: Optional[Arn]
    def clientId: Optional[ClientId]
    def getDataIntegrationAssociationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField(
        "dataIntegrationAssociationArn",
        dataIntegrationAssociationArn
      )
    def getDataIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("dataIntegrationArn", dataIntegrationArn)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary
  ) extends zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly {
    override val dataIntegrationAssociationArn: Optional[Arn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataIntegrationAssociationArn())
        .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val dataIntegrationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.dataIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.appintegrations.model.primitives.ClientId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.DataIntegrationAssociationSummary
  ): zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly =
    new Wrapper(impl)
}
