package zio.aws.appintegrations
import zio.prelude.Subtype
import zio.aws.appintegrations.model.primitives.{
  Fields,
  TagValue,
  NonBlankString,
  ApplicationTrustedSource,
  NonBlankLongString,
  TagKey
}
import java.time.Instant
import zio.aws.appintegrations.model.primitives.ClientId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ApplicationName extends Subtype[String]
    type ApplicationName =
      zio.aws.appintegrations.model.primitives.ApplicationName.Type
    object ApplicationNamespace extends Subtype[String]
    type ApplicationNamespace =
      zio.aws.appintegrations.model.primitives.ApplicationNamespace.Type
    object ApplicationTrustedSource extends Subtype[String]
    type ApplicationTrustedSource =
      zio.aws.appintegrations.model.primitives.ApplicationTrustedSource.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.appintegrations.model.primitives.Arn.Type
    object ArnOrUUID extends Subtype[String]
    type ArnOrUUID = zio.aws.appintegrations.model.primitives.ArnOrUUID.Type
    object ClientId extends Subtype[String]
    type ClientId = zio.aws.appintegrations.model.primitives.ClientId.Type
    object Description extends Subtype[String]
    type Description = zio.aws.appintegrations.model.primitives.Description.Type
    object EventBridgeBus extends Subtype[String]
    type EventBridgeBus =
      zio.aws.appintegrations.model.primitives.EventBridgeBus.Type
    object EventBridgeRuleName extends Subtype[String]
    type EventBridgeRuleName =
      zio.aws.appintegrations.model.primitives.EventBridgeRuleName.Type
    object EventDefinitionSchema extends Subtype[String]
    type EventDefinitionSchema =
      zio.aws.appintegrations.model.primitives.EventDefinitionSchema.Type
    object EventName extends Subtype[String]
    type EventName = zio.aws.appintegrations.model.primitives.EventName.Type
    object Fields extends Subtype[String]
    type Fields = zio.aws.appintegrations.model.primitives.Fields.Type
    object IdempotencyToken extends Subtype[String]
    type IdempotencyToken =
      zio.aws.appintegrations.model.primitives.IdempotencyToken.Type
    object Identifier extends Subtype[String]
    type Identifier = zio.aws.appintegrations.model.primitives.Identifier.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.appintegrations.model.primitives.MaxResults.Type
    object Name extends Subtype[String]
    type Name = zio.aws.appintegrations.model.primitives.Name.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.appintegrations.model.primitives.NextToken.Type
    object NonBlankLongString extends Subtype[String]
    type NonBlankLongString =
      zio.aws.appintegrations.model.primitives.NonBlankLongString.Type
    object NonBlankString extends Subtype[String]
    type NonBlankString =
      zio.aws.appintegrations.model.primitives.NonBlankString.Type
    object Object extends Subtype[String]
    type Object = zio.aws.appintegrations.model.primitives.Object.Type
    object Source extends Subtype[String]
    type Source = zio.aws.appintegrations.model.primitives.Source.Type
    object SourceURI extends Subtype[String]
    type SourceURI = zio.aws.appintegrations.model.primitives.SourceURI.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.appintegrations.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.appintegrations.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.appintegrations.model.primitives.Timestamp.Type
    object URL extends Subtype[String]
    type URL = zio.aws.appintegrations.model.primitives.URL.Type
    object UUID extends Subtype[String]
    type UUID = zio.aws.appintegrations.model.primitives.UUID.Type
  }
  type ApplicationApprovedOrigins = List[ApplicationTrustedSource]
  type ApplicationsList = List[zio.aws.appintegrations.model.ApplicationSummary]
  type ClientAssociationMetadata = Map[NonBlankString, NonBlankString]
  type DataIntegrationAssociationsList =
    List[zio.aws.appintegrations.model.DataIntegrationAssociationSummary]
  type DataIntegrationsList =
    List[zio.aws.appintegrations.model.DataIntegrationSummary]
  type EventIntegrationAssociationsList =
    List[zio.aws.appintegrations.model.EventIntegrationAssociation]
  type EventIntegrationsList =
    List[zio.aws.appintegrations.model.EventIntegration]
  type FieldsList = List[Fields]
  type FieldsMap = Map[NonBlankString, Iterable[Fields]]
  type FolderList = List[NonBlankLongString]
  type ObjectConfiguration =
    Map[NonBlankString, Map[NonBlankString, Iterable[Fields]]]
  type PublicationList = List[zio.aws.appintegrations.model.Publication]
  type SubscriptionList = List[zio.aws.appintegrations.model.Subscription]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
}
