package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{Description, EventName}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Subscription(
    event: EventName,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.Subscription
      .builder()
      .event(EventName.unwrap(event): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.Subscription.ReadOnly =
    zio.aws.appintegrations.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.Subscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.Subscription =
      zio.aws.appintegrations.model
        .Subscription(event, description.map(value => value))
    def event: EventName
    def description: Optional[Description]
    def getEvent: ZIO[Any, Nothing, EventName] = ZIO.succeed(event)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.Subscription
  ) extends zio.aws.appintegrations.model.Subscription.ReadOnly {
    override val event: EventName =
      zio.aws.appintegrations.model.primitives.EventName(impl.event())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.Subscription
  ): zio.aws.appintegrations.model.Subscription.ReadOnly = new Wrapper(impl)
}
