package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  Description,
  EventDefinitionSchema,
  EventName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Publication(
    event: EventName,
    schema: EventDefinitionSchema,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.Publication = {
    import Publication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.Publication
      .builder()
      .event(EventName.unwrap(event): java.lang.String)
      .schema(EventDefinitionSchema.unwrap(schema): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.Publication.ReadOnly =
    zio.aws.appintegrations.model.Publication.wrap(buildAwsValue())
}
object Publication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.Publication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.Publication =
      zio.aws.appintegrations.model
        .Publication(event, schema, description.map(value => value))
    def event: EventName
    def schema: EventDefinitionSchema
    def description: Optional[Description]
    def getEvent: ZIO[Any, Nothing, EventName] = ZIO.succeed(event)
    def getSchema: ZIO[Any, Nothing, EventDefinitionSchema] =
      ZIO.succeed(schema)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.Publication
  ) extends zio.aws.appintegrations.model.Publication.ReadOnly {
    override val event: EventName =
      zio.aws.appintegrations.model.primitives.EventName(impl.event())
    override val schema: EventDefinitionSchema =
      zio.aws.appintegrations.model.primitives
        .EventDefinitionSchema(impl.schema())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.Publication
  ): zio.aws.appintegrations.model.Publication.ReadOnly = new Wrapper(impl)
}
