package zio.aws.appintegrations.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.appintegrations.model.primitives.{
  ApplicationNamespace,
  ApplicationName,
  Timestamp,
  TagValue,
  Arn,
  Description,
  UUID,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetApplicationResponse(
    arn: Optional[Arn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[ApplicationName] = Optional.Absent,
    namespace: Optional[ApplicationNamespace] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig
    ] = Optional.Absent,
    subscriptions: Optional[
      Iterable[zio.aws.appintegrations.model.Subscription]
    ] = Optional.Absent,
    publications: Optional[
      Iterable[zio.aws.appintegrations.model.Publication]
    ] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse = {
    import GetApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        namespace.map(value =>
          ApplicationNamespace.unwrap(value): java.lang.String
        )
      )(_.namespace)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        applicationSourceConfig.map(value => value.buildAwsValue())
      )(_.applicationSourceConfig)
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .optionallyWith(
        publications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.publications)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly =
    zio.aws.appintegrations.model.GetApplicationResponse.wrap(buildAwsValue())
}
object GetApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.GetApplicationResponse =
      zio.aws.appintegrations.model.GetApplicationResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        namespace.map(value => value),
        description.map(value => value),
        applicationSourceConfig.map(value => value.asEditable),
        subscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTime.map(value => value),
        lastModifiedTime.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[Arn]
    def id: Optional[UUID]
    def name: Optional[ApplicationName]
    def namespace: Optional[ApplicationNamespace]
    def description: Optional[Description]
    def applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ]
    def subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]]
    def publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getNamespace: ZIO[Any, AwsError, ApplicationNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationSourceConfig: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "applicationSourceConfig",
      applicationSourceConfig
    )
    def getSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Subscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptions", subscriptions)
    def getPublications: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Publication.ReadOnly
    ]] = AwsError.unwrapOptionField("publications", publications)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse
  ) extends zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.appintegrations.model.primitives.ApplicationName(value)
      )
    override val namespace: Optional[ApplicationNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value =>
          zio.aws.appintegrations.model.primitives.ApplicationNamespace(value)
        )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val applicationSourceConfig: Optional[
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSourceConfig())
      .map(value =>
        zio.aws.appintegrations.model.ApplicationSourceConfig.wrap(value)
      )
    override val subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Subscription.wrap(item)
          }.toList
        )
    override val publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Publication.wrap(item)
          }.toList
        )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appintegrations.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.appintegrations.model.primitives.Timestamp(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.GetApplicationResponse
  ): zio.aws.appintegrations.model.GetApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
