package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  Fields,
  NonBlankString,
  NonBlankLongString
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileConfiguration(
    folders: Iterable[NonBlankLongString],
    filters: Optional[Map[NonBlankString, Iterable[Fields]]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.FileConfiguration = {
    import FileConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.FileConfiguration
      .builder()
      .folders(folders.map { item =>
        NonBlankLongString.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              (NonBlankString.unwrap(key): java.lang.String) -> value.map {
                item =>
                  Fields.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.FileConfiguration.ReadOnly =
    zio.aws.appintegrations.model.FileConfiguration.wrap(buildAwsValue())
}
object FileConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.FileConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.FileConfiguration =
      zio.aws.appintegrations.model
        .FileConfiguration(folders, filters.map(value => value))
    def folders: List[NonBlankLongString]
    def filters: Optional[Map[NonBlankString, List[Fields]]]
    def getFolders: ZIO[Any, Nothing, List[NonBlankLongString]] =
      ZIO.succeed(folders)
    def getFilters: ZIO[Any, AwsError, Map[NonBlankString, List[Fields]]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.FileConfiguration
  ) extends zio.aws.appintegrations.model.FileConfiguration.ReadOnly {
    override val folders: List[NonBlankLongString] = impl
      .folders()
      .asScala
      .map { item =>
        zio.aws.appintegrations.model.primitives.NonBlankLongString(item)
      }
      .toList
    override val filters: Optional[Map[NonBlankString, List[Fields]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.appintegrations.model.primitives
                .NonBlankString(key) -> value.asScala.map { item =>
                zio.aws.appintegrations.model.primitives.Fields(item)
              }.toList
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.FileConfiguration
  ): zio.aws.appintegrations.model.FileConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
