package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{ApplicationTrustedSource, URL}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExternalUrlConfig(
    accessUrl: URL,
    approvedOrigins: Optional[Iterable[ApplicationTrustedSource]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ExternalUrlConfig = {
    import ExternalUrlConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ExternalUrlConfig
      .builder()
      .accessUrl(URL.unwrap(accessUrl): java.lang.String)
      .optionallyWith(
        approvedOrigins.map(value =>
          value.map { item =>
            ApplicationTrustedSource.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.approvedOrigins)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly =
    zio.aws.appintegrations.model.ExternalUrlConfig.wrap(buildAwsValue())
}
object ExternalUrlConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ExternalUrlConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ExternalUrlConfig =
      zio.aws.appintegrations.model
        .ExternalUrlConfig(accessUrl, approvedOrigins.map(value => value))
    def accessUrl: URL
    def approvedOrigins: Optional[List[ApplicationTrustedSource]]
    def getAccessUrl: ZIO[Any, Nothing, URL] = ZIO.succeed(accessUrl)
    def getApprovedOrigins: ZIO[Any, AwsError, List[ApplicationTrustedSource]] =
      AwsError.unwrapOptionField("approvedOrigins", approvedOrigins)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ExternalUrlConfig
  ) extends zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly {
    override val accessUrl: URL =
      zio.aws.appintegrations.model.primitives.URL(impl.accessUrl())
    override val approvedOrigins: Optional[List[ApplicationTrustedSource]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approvedOrigins())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.primitives
              .ApplicationTrustedSource(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ExternalUrlConfig
  ): zio.aws.appintegrations.model.ExternalUrlConfig.ReadOnly = new Wrapper(
    impl
  )
}
