package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{UUID, Arn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationResponse(
    arn: Optional[Arn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse = {
    import CreateApplicationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly =
    zio.aws.appintegrations.model.CreateApplicationResponse
      .wrap(buildAwsValue())
}
object CreateApplicationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.CreateApplicationResponse =
      zio.aws.appintegrations.model.CreateApplicationResponse(
        arn.map(value => value),
        id.map(value => value)
      )
    def arn: Optional[Arn]
    def id: Optional[UUID]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse
  ) extends zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateApplicationResponse
  ): zio.aws.appintegrations.model.CreateApplicationResponse.ReadOnly =
    new Wrapper(impl)
}
