package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  ApplicationNamespace,
  ApplicationName,
  TagValue,
  IdempotencyToken,
  Description,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateApplicationRequest(
    name: ApplicationName,
    namespace: ApplicationNamespace,
    description: Optional[Description] = Optional.Absent,
    applicationSourceConfig: zio.aws.appintegrations.model.ApplicationSourceConfig,
    subscriptions: Optional[
      Iterable[zio.aws.appintegrations.model.Subscription]
    ] = Optional.Absent,
    publications: Optional[
      Iterable[zio.aws.appintegrations.model.Publication]
    ] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest = {
    import CreateApplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest
      .builder()
      .name(ApplicationName.unwrap(name): java.lang.String)
      .namespace(ApplicationNamespace.unwrap(namespace): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .applicationSourceConfig(applicationSourceConfig.buildAwsValue())
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .optionallyWith(
        publications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.publications)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateApplicationRequest.ReadOnly =
    zio.aws.appintegrations.model.CreateApplicationRequest.wrap(buildAwsValue())
}
object CreateApplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.CreateApplicationRequest =
      zio.aws.appintegrations.model.CreateApplicationRequest(
        name,
        namespace,
        description.map(value => value),
        applicationSourceConfig.asEditable,
        subscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        publications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        tags.map(value => value)
      )
    def name: ApplicationName
    def namespace: ApplicationNamespace
    def description: Optional[Description]
    def applicationSourceConfig
        : zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    def subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]]
    def publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]]
    def clientToken: Optional[IdempotencyToken]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, ApplicationName] = ZIO.succeed(name)
    def getNamespace: ZIO[Any, Nothing, ApplicationNamespace] =
      ZIO.succeed(namespace)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getApplicationSourceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly
    ] = ZIO.succeed(applicationSourceConfig)
    def getSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Subscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptions", subscriptions)
    def getPublications: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.Publication.ReadOnly
    ]] = AwsError.unwrapOptionField("publications", publications)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest
  ) extends zio.aws.appintegrations.model.CreateApplicationRequest.ReadOnly {
    override val name: ApplicationName =
      zio.aws.appintegrations.model.primitives.ApplicationName(impl.name())
    override val namespace: ApplicationNamespace =
      zio.aws.appintegrations.model.primitives
        .ApplicationNamespace(impl.namespace())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val applicationSourceConfig
        : zio.aws.appintegrations.model.ApplicationSourceConfig.ReadOnly =
      zio.aws.appintegrations.model.ApplicationSourceConfig
        .wrap(impl.applicationSourceConfig())
    override val subscriptions
        : Optional[List[zio.aws.appintegrations.model.Subscription.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subscriptions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Subscription.wrap(item)
          }.toList
        )
    override val publications
        : Optional[List[zio.aws.appintegrations.model.Publication.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.publications())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.appintegrations.model.Publication.wrap(item)
          }.toList
        )
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateApplicationRequest
  ): zio.aws.appintegrations.model.CreateApplicationRequest.ReadOnly =
    new Wrapper(impl)
}
