package zio.aws.appintegrations.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.appintegrations.model.primitives.{
  ApplicationNamespace,
  ApplicationName,
  Timestamp,
  Arn,
  UUID
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class ApplicationSummary(
    arn: Optional[Arn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[ApplicationName] = Optional.Absent,
    namespace: Optional[ApplicationNamespace] = Optional.Absent,
    createdTime: Optional[Timestamp] = Optional.Absent,
    lastModifiedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ApplicationSummary = {
    import ApplicationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ApplicationSummary
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => ApplicationName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        namespace.map(value =>
          ApplicationNamespace.unwrap(value): java.lang.String
        )
      )(_.namespace)
      .optionallyWith(
        createdTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        lastModifiedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastModifiedTime)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.ApplicationSummary.ReadOnly =
    zio.aws.appintegrations.model.ApplicationSummary.wrap(buildAwsValue())
}
object ApplicationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ApplicationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ApplicationSummary =
      zio.aws.appintegrations.model.ApplicationSummary(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        namespace.map(value => value),
        createdTime.map(value => value),
        lastModifiedTime.map(value => value)
      )
    def arn: Optional[Arn]
    def id: Optional[UUID]
    def name: Optional[ApplicationName]
    def namespace: Optional[ApplicationNamespace]
    def createdTime: Optional[Timestamp]
    def lastModifiedTime: Optional[Timestamp]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ApplicationName] =
      AwsError.unwrapOptionField("name", name)
    def getNamespace: ZIO[Any, AwsError, ApplicationNamespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getCreatedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getLastModifiedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastModifiedTime", lastModifiedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ApplicationSummary
  ) extends zio.aws.appintegrations.model.ApplicationSummary.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
    override val name: Optional[ApplicationName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.appintegrations.model.primitives.ApplicationName(value)
      )
    override val namespace: Optional[ApplicationNamespace] =
      zio.aws.core.internal
        .optionalFromNullable(impl.namespace())
        .map(value =>
          zio.aws.appintegrations.model.primitives.ApplicationNamespace(value)
        )
    override val createdTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.appintegrations.model.primitives.Timestamp(value))
    override val lastModifiedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedTime())
      .map(value => zio.aws.appintegrations.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ApplicationSummary
  ): zio.aws.appintegrations.model.ApplicationSummary.ReadOnly = new Wrapper(
    impl
  )
}
