package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{Description, Name}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateEventIntegrationRequest(
    name: Name,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest = {
    import UpdateEventIntegrationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.UpdateEventIntegrationRequest.ReadOnly =
    zio.aws.appintegrations.model.UpdateEventIntegrationRequest
      .wrap(buildAwsValue())
}
object UpdateEventIntegrationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.UpdateEventIntegrationRequest =
      zio.aws.appintegrations.model
        .UpdateEventIntegrationRequest(name, description.map(value => value))
    def name: Name
    def description: Optional[Description]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest
  ) extends zio.aws.appintegrations.model.UpdateEventIntegrationRequest.ReadOnly {
    override val name: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.UpdateEventIntegrationRequest
  ): zio.aws.appintegrations.model.UpdateEventIntegrationRequest.ReadOnly =
    new Wrapper(impl)
}
