package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListEventIntegrationAssociationsResponse(
    eventIntegrationAssociations: Optional[
      Iterable[zio.aws.appintegrations.model.EventIntegrationAssociation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse = {
    import ListEventIntegrationAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse
      .builder()
      .optionallyWith(
        eventIntegrationAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventIntegrationAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse
      .wrap(buildAwsValue())
}
object ListEventIntegrationAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse =
      zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse(
        eventIntegrationAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def eventIntegrationAssociations: Optional[
      List[zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getEventIntegrationAssociations: ZIO[Any, AwsError, List[
      zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventIntegrationAssociations",
      eventIntegrationAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse
  ) extends zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly {
    override val eventIntegrationAssociations: Optional[
      List[zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventIntegrationAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appintegrations.model.EventIntegrationAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsResponse
  ): zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
