package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.Arn
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateEventIntegrationResponse(
    eventIntegrationArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse = {
    import CreateEventIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
      .builder()
      .optionallyWith(
        eventIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventIntegrationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly =
    zio.aws.appintegrations.model.CreateEventIntegrationResponse
      .wrap(buildAwsValue())
}
object CreateEventIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.CreateEventIntegrationResponse =
      zio.aws.appintegrations.model
        .CreateEventIntegrationResponse(eventIntegrationArn.map(value => value))
    def eventIntegrationArn: Optional[Arn]
    def getEventIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventIntegrationArn", eventIntegrationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ) extends zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly {
    override val eventIntegrationArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.eventIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateEventIntegrationResponse
  ): zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
