package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  TagValue,
  Arn,
  IdempotencyToken,
  Description,
  NonBlankString,
  UUID,
  Name,
  TagKey
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateDataIntegrationResponse(
    arn: Optional[Arn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    name: Optional[Name] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    kmsKey: Optional[NonBlankString] = Optional.Absent,
    sourceURI: Optional[NonBlankString] = Optional.Absent,
    scheduleConfiguration: Optional[
      zio.aws.appintegrations.model.ScheduleConfiguration
    ] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    clientToken: Optional[IdempotencyToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse = {
    import CreateDataIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
      .builder()
      .optionallyWith(arn.map(value => Arn.unwrap(value): java.lang.String))(
        _.arn
      )
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        kmsKey.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        sourceURI.map(value => NonBlankString.unwrap(value): java.lang.String)
      )(_.sourceURI)
      .optionallyWith(
        scheduleConfiguration.map(value => value.buildAwsValue())
      )(_.scheduleConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value =>
          IdempotencyToken.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly =
    zio.aws.appintegrations.model.CreateDataIntegrationResponse
      .wrap(buildAwsValue())
}
object CreateDataIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.CreateDataIntegrationResponse =
      zio.aws.appintegrations.model.CreateDataIntegrationResponse(
        arn.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        kmsKey.map(value => value),
        sourceURI.map(value => value),
        scheduleConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        clientToken.map(value => value)
      )
    def arn: Optional[Arn]
    def id: Optional[UUID]
    def name: Optional[Name]
    def description: Optional[Description]
    def kmsKey: Optional[NonBlankString]
    def sourceURI: Optional[NonBlankString]
    def scheduleConfiguration
        : Optional[zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def clientToken: Optional[IdempotencyToken]
    def getArn: ZIO[Any, AwsError, Arn] = AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getKmsKey: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getSourceURI: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("sourceURI", sourceURI)
    def getScheduleConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("scheduleConfiguration", scheduleConfiguration)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, IdempotencyToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ) extends zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly {
    override val arn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.appintegrations.model.primitives.UUID(value))
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val kmsKey: Optional[NonBlankString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val sourceURI: Optional[NonBlankString] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceURI())
      .map(value =>
        zio.aws.appintegrations.model.primitives.NonBlankString(value)
      )
    override val scheduleConfiguration: Optional[
      zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduleConfiguration())
      .map(value =>
        zio.aws.appintegrations.model.ScheduleConfiguration.wrap(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val clientToken: Optional[IdempotencyToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.appintegrations.model.primitives.IdempotencyToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.CreateDataIntegrationResponse
  ): zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
