package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appintegrations.model.primitives.Source
import scala.jdk.CollectionConverters._
final case class EventFilter(source: Source) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.EventFilter = {
    import EventFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.EventFilter
      .builder()
      .source(Source.unwrap(source): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.EventFilter.ReadOnly =
    zio.aws.appintegrations.model.EventFilter.wrap(buildAwsValue())
}
object EventFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.EventFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.EventFilter =
      zio.aws.appintegrations.model.EventFilter(source)
    def source: Source
    def getSource: ZIO[Any, Nothing, Source] = ZIO.succeed(source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.EventFilter
  ) extends zio.aws.appintegrations.model.EventFilter.ReadOnly {
    override val source: Source =
      zio.aws.appintegrations.model.primitives.Source(impl.source())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.EventFilter
  ): zio.aws.appintegrations.model.EventFilter.ReadOnly = new Wrapper(impl)
}
