package zio.aws.appintegrations.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  MaxResults,
  NextToken,
  Identifier
}
import scala.jdk.CollectionConverters._
final case class ListDataIntegrationAssociationsRequest(
    dataIntegrationIdentifier: Identifier,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest = {
    import ListDataIntegrationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
      .builder()
      .dataIntegrationIdentifier(
        Identifier.unwrap(dataIntegrationIdentifier): java.lang.String
      )
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest
      .wrap(buildAwsValue())
}
object ListDataIntegrationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest =
      zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest(
        dataIntegrationIdentifier,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def dataIntegrationIdentifier: Identifier
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getDataIntegrationIdentifier: ZIO[Any, Nothing, Identifier] =
      ZIO.succeed(dataIntegrationIdentifier)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ) extends zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly {
    override val dataIntegrationIdentifier: Identifier =
      zio.aws.appintegrations.model.primitives
        .Identifier(impl.dataIntegrationIdentifier())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListDataIntegrationAssociationsRequest
  ): zio.aws.appintegrations.model.ListDataIntegrationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
