package zio.aws.appintegrations
import zio.aws.appintegrations.model.EventIntegrationAssociation.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.appintegrations.AppIntegrationsAsyncClient
import zio.aws.core.AwsError
import zio.aws.appintegrations.model.{
  UpdateDataIntegrationRequest,
  GetDataIntegrationRequest,
  ListEventIntegrationsRequest,
  UpdateEventIntegrationRequest,
  ListTagsForResourceRequest,
  DeleteEventIntegrationRequest,
  GetEventIntegrationRequest,
  ListEventIntegrationAssociationsRequest,
  CreateEventIntegrationRequest,
  UntagResourceRequest,
  ListDataIntegrationsRequest,
  CreateDataIntegrationRequest,
  DeleteDataIntegrationRequest,
  ListDataIntegrationAssociationsRequest,
  TagResourceRequest
}
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object AppIntegrationsMock extends Mock[AppIntegrations] {
  object ListEventIntegrations
      extends Stream[
        ListEventIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.EventIntegration.ReadOnly
      ]
  object ListEventIntegrationsPaginated
      extends Effect[
        ListEventIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
      ]
  object CreateEventIntegration
      extends Effect[
        CreateEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
      ]
  object ListEventIntegrationAssociations
      extends Stream[
        ListEventIntegrationAssociationsRequest,
        AwsError,
        ReadOnly
      ]
  object ListEventIntegrationAssociationsPaginated
      extends Effect[
        ListEventIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
      ]
  object ListDataIntegrationAssociations
      extends Stream[
        ListDataIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
      ]
  object ListDataIntegrationAssociationsPaginated
      extends Effect[
        ListDataIntegrationAssociationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
      ]
  object GetDataIntegration
      extends Effect[
        GetDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
      ]
  object GetEventIntegration
      extends Effect[
        GetEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
      ]
  object DeleteDataIntegration
      extends Effect[
        DeleteDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
      ]
  object UpdateEventIntegration
      extends Effect[
        UpdateEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
      ]
  object DeleteEventIntegration
      extends Effect[
        DeleteEventIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
      ]
  object CreateDataIntegration
      extends Effect[
        CreateDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
      ]
  object UpdateDataIntegration
      extends Effect[
        UpdateDataIntegrationRequest,
        AwsError,
        zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
      ]
  object ListDataIntegrations
      extends Stream[
        ListDataIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
      ]
  object ListDataIntegrationsPaginated
      extends Effect[
        ListDataIntegrationsRequest,
        AwsError,
        zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppIntegrations] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AppIntegrations {
          val api: AppIntegrationsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AppIntegrations = this
          def listEventIntegrations(
              request: ListEventIntegrationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.appintegrations.model.EventIntegration.ReadOnly
          ] = rts.unsafeRun(proxy(ListEventIntegrations, request))
          def listEventIntegrationsPaginated(
              request: ListEventIntegrationsRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.ListEventIntegrationsResponse.ReadOnly
          ] = proxy(ListEventIntegrationsPaginated, request)
          def createEventIntegration(
              request: CreateEventIntegrationRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.CreateEventIntegrationResponse.ReadOnly
          ] = proxy(CreateEventIntegration, request)
          def listEventIntegrationAssociations(
              request: ListEventIntegrationAssociationsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListEventIntegrationAssociations, request))
          def listEventIntegrationAssociationsPaginated(
              request: ListEventIntegrationAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.ListEventIntegrationAssociationsResponse.ReadOnly
          ] = proxy(ListEventIntegrationAssociationsPaginated, request)
          def listDataIntegrationAssociations(
              request: ListDataIntegrationAssociationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.appintegrations.model.DataIntegrationAssociationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataIntegrationAssociations, request))
          def listDataIntegrationAssociationsPaginated(
              request: ListDataIntegrationAssociationsRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.ListDataIntegrationAssociationsResponse.ReadOnly
          ] = proxy(ListDataIntegrationAssociationsPaginated, request)
          def getDataIntegration(request: GetDataIntegrationRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.GetDataIntegrationResponse.ReadOnly
          ] = proxy(GetDataIntegration, request)
          def getEventIntegration(request: GetEventIntegrationRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly
          ] = proxy(GetEventIntegration, request)
          def deleteDataIntegration(request: DeleteDataIntegrationRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.DeleteDataIntegrationResponse.ReadOnly
          ] = proxy(DeleteDataIntegration, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def updateEventIntegration(
              request: UpdateEventIntegrationRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.UpdateEventIntegrationResponse.ReadOnly
          ] = proxy(UpdateEventIntegration, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def deleteEventIntegration(
              request: DeleteEventIntegrationRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.DeleteEventIntegrationResponse.ReadOnly
          ] = proxy(DeleteEventIntegration, request)
          def createDataIntegration(request: CreateDataIntegrationRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.CreateDataIntegrationResponse.ReadOnly
          ] = proxy(CreateDataIntegration, request)
          def updateDataIntegration(request: UpdateDataIntegrationRequest): IO[
            AwsError,
            zio.aws.appintegrations.model.UpdateDataIntegrationResponse.ReadOnly
          ] = proxy(UpdateDataIntegration, request)
          def listDataIntegrations(
              request: ListDataIntegrationsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.appintegrations.model.DataIntegrationSummary.ReadOnly
          ] = rts.unsafeRun(proxy(ListDataIntegrations, request))
          def listDataIntegrationsPaginated(
              request: ListDataIntegrationsRequest
          ): IO[
            AwsError,
            zio.aws.appintegrations.model.ListDataIntegrationsResponse.ReadOnly
          ] = proxy(ListDataIntegrationsPaginated, request)
        }
      }
    }
    .toLayer
}
