package zio.aws.appintegrations.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{MaxResults, NextToken, Name}
import scala.jdk.CollectionConverters._
final case class ListEventIntegrationAssociationsRequest(
    eventIntegrationName: Name,
    nextToken: Option[NextToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest = {
    import ListEventIntegrationAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
      .builder()
      .eventIntegrationName(Name.unwrap(eventIntegrationName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly =
    zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest
      .wrap(buildAwsValue())
}
object ListEventIntegrationAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest =
      zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest(
        eventIntegrationName,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def eventIntegrationName: Name
    def nextToken: Option[NextToken]
    def maxResults: Option[MaxResults]
    def getEventIntegrationName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(eventIntegrationName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ) extends zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly {
    override val eventIntegrationName: Name =
      zio.aws.appintegrations.model.primitives.Name(impl.eventIntegrationName())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.appintegrations.model.primitives.NextToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.appintegrations.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ListEventIntegrationAssociationsRequest
  ): zio.aws.appintegrations.model.ListEventIntegrationAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
