package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{
  EventBridgeBus,
  TagValue,
  Arn,
  Description,
  Name,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class GetEventIntegrationResponse(
    name: Option[Name] = None,
    description: Option[Description] = None,
    eventIntegrationArn: Option[Arn] = None,
    eventBridgeBus: Option[EventBridgeBus] = None,
    eventFilter: Option[zio.aws.appintegrations.model.EventFilter] = None,
    tags: Option[Map[TagKey, TagValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse = {
    import GetEventIntegrationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse
      .builder()
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        eventIntegrationArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.eventIntegrationArn)
      .optionallyWith(
        eventBridgeBus.map(value =>
          EventBridgeBus.unwrap(value): java.lang.String
        )
      )(_.eventBridgeBus)
      .optionallyWith(eventFilter.map(value => value.buildAwsValue()))(
        _.eventFilter
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly =
    zio.aws.appintegrations.model.GetEventIntegrationResponse
      .wrap(buildAwsValue())
}
object GetEventIntegrationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.GetEventIntegrationResponse =
      zio.aws.appintegrations.model.GetEventIntegrationResponse(
        name.map(value => value),
        description.map(value => value),
        eventIntegrationArn.map(value => value),
        eventBridgeBus.map(value => value),
        eventFilter.map(value => value.asEditable),
        tags.map(value => value)
      )
    def name: Option[Name]
    def description: Option[Description]
    def eventIntegrationArn: Option[Arn]
    def eventBridgeBus: Option[EventBridgeBus]
    def eventFilter: Option[zio.aws.appintegrations.model.EventFilter.ReadOnly]
    def tags: Option[Map[TagKey, TagValue]]
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEventIntegrationArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("eventIntegrationArn", eventIntegrationArn)
    def getEventBridgeBus: ZIO[Any, AwsError, EventBridgeBus] =
      AwsError.unwrapOptionField("eventBridgeBus", eventBridgeBus)
    def getEventFilter: ZIO[
      Any,
      AwsError,
      zio.aws.appintegrations.model.EventFilter.ReadOnly
    ] = AwsError.unwrapOptionField("eventFilter", eventFilter)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse
  ) extends zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly {
    override val name: Option[Name] = scala
      .Option(impl.name())
      .map(value => zio.aws.appintegrations.model.primitives.Name(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.appintegrations.model.primitives.Description(value))
    override val eventIntegrationArn: Option[Arn] = scala
      .Option(impl.eventIntegrationArn())
      .map(value => zio.aws.appintegrations.model.primitives.Arn(value))
    override val eventBridgeBus: Option[EventBridgeBus] = scala
      .Option(impl.eventBridgeBus())
      .map(value =>
        zio.aws.appintegrations.model.primitives.EventBridgeBus(value)
      )
    override val eventFilter
        : Option[zio.aws.appintegrations.model.EventFilter.ReadOnly] = scala
      .Option(impl.eventFilter())
      .map(value => zio.aws.appintegrations.model.EventFilter.wrap(value))
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.appintegrations.model.primitives.TagKey(
              key
            ) -> zio.aws.appintegrations.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.GetEventIntegrationResponse
  ): zio.aws.appintegrations.model.GetEventIntegrationResponse.ReadOnly =
    new Wrapper(impl)
}
