package zio.aws.appintegrations.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appintegrations.model.primitives.{Object, NonBlankString}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduleConfiguration(
    firstExecutionFrom: Optional[NonBlankString] = Optional.Absent,
    `object`: Optional[Object] = Optional.Absent,
    scheduleExpression: NonBlankString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration = {
    import ScheduleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
      .builder()
      .optionallyWith(
        firstExecutionFrom.map(value =>
          NonBlankString.unwrap(value): java.lang.String
        )
      )(_.firstExecutionFrom)
      .optionallyWith(
        `object`.map(value => Object.unwrap(value): java.lang.String)
      )(_.`object`)
      .scheduleExpression(
        NonBlankString.unwrap(scheduleExpression): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly =
    zio.aws.appintegrations.model.ScheduleConfiguration.wrap(buildAwsValue())
}
object ScheduleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appintegrations.model.ScheduleConfiguration =
      zio.aws.appintegrations.model.ScheduleConfiguration(
        firstExecutionFrom.map(value => value),
        `object`.map(value => value),
        scheduleExpression
      )
    def firstExecutionFrom: Optional[NonBlankString]
    def `object`: Optional[Object]
    def scheduleExpression: NonBlankString
    def getFirstExecutionFrom: ZIO[Any, AwsError, NonBlankString] =
      AwsError.unwrapOptionField("firstExecutionFrom", firstExecutionFrom)
    def getObject: ZIO[Any, AwsError, Object] =
      AwsError.unwrapOptionField("object", `object`)
    def getScheduleExpression: ZIO[Any, Nothing, NonBlankString] =
      ZIO.succeed(scheduleExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ) extends zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly {
    override val firstExecutionFrom: Optional[NonBlankString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.firstExecutionFrom())
        .map(value =>
          zio.aws.appintegrations.model.primitives.NonBlankString(value)
        )
    override val `object`: Optional[Object] = zio.aws.core.internal
      .optionalFromNullable(impl.`object`())
      .map(value => zio.aws.appintegrations.model.primitives.Object(value))
    override val scheduleExpression: NonBlankString =
      zio.aws.appintegrations.model.primitives
        .NonBlankString(impl.scheduleExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appintegrations.model.ScheduleConfiguration
  ): zio.aws.appintegrations.model.ScheduleConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
